
############# Kernel information ##############

KERNEL_LOCALVERSION=$(shell test -f "$(KERNEL_CONFIG_FILE)" && grep CONFIG_LOCALVERSION= "$(KERNEL_CONFIG_FILE)" | cut -f2 -d\")
KERNEL_WORKSRC ?= $(WORKDIR)/linux-$(KERNEL_VERSION)
KERNEL_MODDIR=/lib/modules/$(KERNEL_VERSION)$(KERNEL_LOCALVERSION)
VERSION_MD5 = $(word 1,$(shell test -f "$(KERNEL_CONFIG_FILE)" && (echo -n $(KERNEL_VERSION); cat "$(KERNEL_CONFIG_FILE)") | md5sum ))

#################### Rules ####################

pre-everything:
	@if test -z "$(KERNEL_VERSION)" || test -z "$(KERNEL_CONFIG_FILE)" || test -z "$(KERNEL_MODSYMVERS)"; then cat files/usage.txt; exit 1; fi
	@if ! test -f "$(KERNEL_CONFIG_FILE)"; then echo -e "\n$(ERRORCOLOR)Error: Could not read the kernel configuration file '$(KERNEL_CONFIG_FILE)'$(CLEAR)\n"; exit 1; fi
	@if ! test -f "$(KERNEL_MODSYMVERS)"; then echo -e "\n$(ERRORCOLOR)Error: Could not read the kernel module symvers file '$(KERNEL_MODSYMVERS)'$(CLEAR)\n"; exit 1; fi

post-fetch: updatesum

pre-configure:
	$(MAKE) $(MFLAGS) -C $(KERNEL_WORKSRC) mrproper
	cp -v $(KERNEL_CONFIG_FILE) $(KERNEL_WORKSRC)/.config
	$(MAKE) $(MFLAGS) -C $(KERNEL_WORKSRC) oldconfig modules_prepare

	@if test -f "$(KERNEL_MODSYMVERS)"; then \
	   cp -v "$(KERNEL_MODSYMVERS)" "$(KERNEL_WORKSRC)/Module.symvers"; \
	else \
	   $(MAKE) $(MFLAGS) -C "$(KERNEL_WORKSRC)"  modules; \
	fi

	$(MAKECOOKIE)
